<?php

class PxlPieChart_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_pie_chart';
    protected $title = 'Case Pie Chart';
    protected $icon = 'eicon-circle-o';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_pie_chart_content","label":"Pie Chart","tab":"content","controls":[{"name":"layout_style","label":"Layout Style","type":"select","default":"pie-chart-default","options":{"pie-chart-default":"Default","pie-chart-style1":"Style 1"}},{"name":"title","label":"Title","type":"textarea","rows":3},{"name":"percent","label":"Percent(%)","type":"number","min":1,"default":50,"separator":"before"},{"name":"chart_size","label":"Chart Size(px)","type":"number","min":1,"default":85},{"name":"line_width","label":"Line Width(px)","type":"number","min":1,"default":5},{"name":"rotate","label":"Rotate(deg)","type":"number","min":1,"default":5},{"name":"bar_color","label":"Bar Color","type":"color"},{"name":"track_color","label":"Track Color","type":"color"},{"name":"line_cap","label":"Line Cap","type":"select","options":{"":"Default","round":"Round","square":"Square"}}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"flex_direction","label":"Flex Direction","type":"choose","separator":"before","control_type":"responsive","options":{"row":{"title":"Row","icon":"eicon-arrow-right"},"column":{"title":"Center","icon":"eicon-arrow-down"}},"selectors":{"{{WRAPPER}} .pxl-pie-chart":"flex-direction: {{VALUE}};"}},{"name":"title_alignment","label":"Title Alignment","type":"choose","control_type":"responsive","separator":"before","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-pie-chart .pxl-title":"text-align: {{VALUE}};"}},{"name":"gap","label":"Gap","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-pie-chart":"gap: {{SIZE}}{{UNIT}};"}},{"name":"max_width","label":"Max Width","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-pie-chart":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_title_style","label":"Title","tab":"style","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pie-chart .pxl-title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-pie-chart .pxl-title"},{"name":"title_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-pie-chart .pxl-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-pie-chart .pxl-title"}]},{"name":"tab_percent_style","label":"percent","tab":"style","controls":[{"name":"percent_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pie-chart .pxl-percent":"color: {{VALUE}};"}},{"name":"percent_typography","type":"typography","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-pie-chart .pxl-percent"},{"name":"percent_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-pie-chart .pxl-percent"},{"name":"percent_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-pie-chart .pxl-percent"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-pie-chart' );
}