<?php

class PxlImageGallery_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_image_gallery';
    protected $title = 'Case Image Gallery';
    protected $icon = 'eicon-gallery-grid';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_image_content","label":"Images","tab":"content","controls":[{"name":"layout_type","label":"Layout Type","type":"select","separator":"before","options":{"grid":"Grid","masonry":"Masonry","carousel":"Carousel"},"default":"grid"},{"name":"images","label":"Add Images","type":"gallery","show_label":true,"default":[]},{"name":"img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":"","condition":[]},{"name":"custom_img_dimension","label":"Dimension Custom","type":"image_dimensions","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"img_dimension":"custom"}},{"name":"is_overlay","label":"Overlay","type":"switcher","separator":"before","default":""},{"name":"overlay_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner .pxl-background-overlay","condition":{"is_overlay!":""}},{"name":"overlay_bg_opacity","label":"Overlay Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner .pxl-background-overlay":"opacity: {{SIZE}};"},"condition":{"is_overlay!":""}},{"name":"_icon","label":"Icon","type":"icons","fa4compatibility":"icon","separator":"before","default":{"value":{"url":"http:\/\/agron.local\/wp-content\/uploads\/2025\/05\/plus.svg","id":948},"library":"svg"}}]},{"name":"tab_image_additional_options","label":"Additional Options","tab":"content","condition":{"layout_type!":"carousel"},"controls":[{"name":"columns","label":"Columns","type":"select","control_type":"responsive","options":{"":"Default","100%":"1","50%":"2","33.3333%":"3","25%":"4","20%":"5","16.66666%":"6"},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item, \r\n                                {{WRAPPER}} .pxl-image-gallery.masonry .grid-sizer":"flex-basis: {{VALUE}}; max-width: {{VALUE}};"}},{"name":"grid_sizer_width","label":"Grid Sizer","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-image-gallery.masonry .grid-sizer":"flex-basis: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}};"},"condition":{"columns":""},"description":"Grid item widths should be multiples of the grid-sizer for accurate layout alignment."},{"name":"masonry_items","label":"Masonry Items","type":"repeater","condition":{"layout_type":"masonry"},"controls":[{"name":"masonry_item_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-image-gallery.masonry .grid-item{{CURRENT_ITEM}}":"flex-basis: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}};"}},{"name":"masonry_item_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-image-gallery.masonry .grid-item{{CURRENT_ITEM}} .grid-item-inner":"height: {{SIZE}}{{UNIT}};"}},{"name":"img_dimension_m","label":"Image Dimension","type":"select","options":{"thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":"full"},{"name":"img_dimension_m_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"img_dimension_m":"custom"}}]},{"name":"item_spacing_block","label":"Spacing Block","type":"slider","control_type":"responsive","size_units":["px","custom"],"separator":"before","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-image-gallery":"--pxl-spacing-block: {{SIZE}}{{UNIT}};"}},{"name":"item_spacing_inline","label":"Spacing Inline","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-image-gallery":"--pxl-spacing-inline: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_carousel_add_opts","label":"Additional Options","tab":"settings","condition":{"layout_type":"carousel"},"controls":[{"name":"swiper_controls","control_type":"tab","tabs":[{"name":"swiper_options","label":"Options","type":"tab","condition":{"layout_type":"carousel"},"controls":[{"name":"slide_boxshadow","label":"Slide with Box Shadow","type":"select","options":{"":"Default","swiper-normal":"No","swiper-boxshadow":"Yes"},"default":""},{"name":"effect","label":"Effect","type":"select","options":{"slide":"Slide","fade":"Fade"},"default":"slide"},{"name":"swiper_divider","type":"divider"},{"name":"allow_touch_move","label":"Allow Touch Move","type":"switcher","default":"true"},{"name":"autoplay","label":"Autoplay","type":"switcher","default":""},{"name":"disable_on_interaction","label":"Pause on Interaction","type":"switcher","default":"","condition":{"autoplay!":""}},{"name":"delay","label":"Delay","type":"number","default":3000,"condition":{"autoplay!":""}},{"name":"loop","label":"Infinite Loop","type":"switcher","default":""},{"name":"speed","label":"Animation Speed","type":"number","default":300,"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-container-fade":"--pxl-spacing-inline: {{VALUE}}ms;"}},{"name":"space_between","label":"Space Between(px)","type":"number","control_type":"responsive","condition":{"effect!":"fade"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner":"--pxl-spacing-inline: {{VALUE}}px;"}},{"name":"swiper_pagination","type":"select","label":"Pagination","separator":"before","options":{"":"None","bullets":"Bullets","progressbar":"Progressbar","fraction":"Fraction"}},{"name":"swiper_navigation","label":"Navigation","type":"switcher","default":""},{"name":"use_swiper_nav_widget","label":"Use Navigation Widget","type":"switcher","default":"","condition":{"swiper_navigation!":""}},{"name":"nav_widget_id","type":"text","label":"Enter ID Your Widget Navigation","condition":{"swiper_navigation!":"","use_swiper_nav_widget!":""},"label_block":true,"description":"You need to enter the unique ID you created from the navigation carousel widget, and the navigation with this ID will function as a navigation carousel."},{"name":"nav_btn_icon_prev","label":"Button Icon Prev","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"http:\/\/agron.local\/wp-content\/uploads\/2025\/06\/arrow-left.svg","id":3614},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_btn_icon_next","label":"Button Icon Next","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"http:\/\/agron.local\/wp-content\/uploads\/2025\/06\/arrow-right.svg","id":3615},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_spacing_top","label":"Spacing Top","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation":"marrgin-top: {{SIZE}}{{UNIT}};"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}}]},{"name":"swiper_responsive","label":"Responsive","type":"tab","controls":[{"name":"custom_slides","label":"Custom Slides","type":"switcher","default":""},{"name":"slides_per_view_xs","label":"Slides Per View(&lt;576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_sm","label":"Slides Per View(\u2265576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_md","label":"Slides Per View(\u2265768px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_lg","label":"Slides Per View(\u2265992px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_xl","label":"Slides Per View(\u22651200px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides_per_view_xxl","label":"Slides Per View(\u22651400px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides","label":"Slides Per View Custom","type":"repeater","condition":{"custom_slides!":""},"controls":[{"name":"slide_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"flex: 0 1 {{SIZE}}{{UNIT}};"}},{"name":"slide_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"slide_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"slide_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"slide_img_dimension":"custom"}}]}]}]}]},{"name":"tab_image_style","label":"Image","tab":"style","controls":[{"name":"image_width","label":"Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner img, {{WRAPPER}} .pxl-swiper .swiper-slide img":"width: {{SIZE}}{{UNIT}};"}},{"name":"image_max_w","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner img, {{WRAPPER}} .pxl-swiper .swiper-slide img":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"image_min_h","label":"Min Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner img, {{WRAPPER}} .pxl-swiper .swiper-slide img":"min-height: {{SIZE}}{{UNIT}};"}},{"name":"image_h","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner img, {{WRAPPER}} .pxl-swiper .swiper-slide img":"height: {{SIZE}}{{UNIT}};"}},{"name":"image_controls","control_type":"tab","separator":"before","tabs":[{"name":"image_normal","label":"Normal","type":"tab","controls":[{"name":"image_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner, {{WRAPPER}} .pxl-swiper .swiper-slide img":"opacity: {{SIZE}};"}},{"name":"image_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner, {{WRAPPER}} .pxl-swiper .swiper-slide img"},{"name":"image_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner, {{WRAPPER}} .pxl-swiper .swiper-slide img"},{"name":"image_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner, {{WRAPPER}} .pxl-swiper .swiper-slide img"},{"name":"image_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner, {{WRAPPER}} .pxl-swiper .swiper-slide img":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"image_hover","label":"Hover","type":"tab","controls":[{"name":"image_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner:hover, \r\n                                                {{WRAPPER}} .pxl-swiper .swiper-slide img:hover":"opacity: {{SIZE}};"}},{"name":"image_hover_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner:hover, \r\n                                            {{WRAPPER}} .pxl-swiper .swiper-slide img:hover"},{"name":"image_hover_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner:hover, \r\n                                            {{WRAPPER}} .pxl-swiper .swiper-slide img:hover"},{"name":"image_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner:hover, \r\n                                            {{WRAPPER}} .pxl-swiper .swiper-slide img:hover"},{"name":"image_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner:hover, \r\n                                                {{WRAPPER}} .pxl-swiper .swiper-slide img:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"image_hover_overlay_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-image-gallery .grid-item-inner:hover .pxl-background-overlay","condition":{"is_overlay!":""}},{"name":"image_hover_overlay_bg_opacity","label":"Overlay Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-image-gallery .grid-item-inner:hover .pxl-background-overlay":"opacity: {{SIZE}};"},"condition":{"is_overlay!":""}}]}]}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-swiper','agron-layout' );
}