<?php

class PxlIconBox_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_icon_box';
    protected $title = 'Case Icon Box';
    protected $icon = 'eicon-icon-box';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_icon_box_content","label":"Icon","tab":"content","controls":[{"name":"icon_box_style","label":"Style","type":"select","default":"icon-box-default","options":{"icon-box-default":"Default","icon-box-style1":"Style 1","icon-box-style2":"Style 2","icon-box-style3":"Style 3","icon-box-style4":"Style 4","icon-box-custom":"Custom"}},{"name":"_icon","label":"Icon","type":"icons","fa4compatibility":"icon","default":{"value":"fas fa-star","library":"Font Awesome 5 Free"}},{"name":"title","label":"Title","type":"text","separator":"before","label_block":true,"default":"Heading Title"},{"name":"title_tag","label":"Title HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":"h6"},{"name":"description","label":"Description","type":"textarea","rows":10,"default":"Lorem ipsum dolor sit amet, consectetur adipiscing elit."},{"name":"link_url","label":"Link URL","type":"url","separator":"before","label_block":true},{"name":"max_width","label":"Max Width","type":"slider","control_type":"responsive","separator":"before","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}}":"max-width: {{SIZE}}{{UNIT}} !important;"}}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"align_items_row","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-v"},"center":{"title":"Center","icon":"eicon-align-center-v"},"end":{"title":"End","icon":"eicon-align-end-v"},"stretch":{"title":"Stretch","icon":"eicon-align-stretch-v"}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper":"align-items: {{VALUE}};"},"condition":{"icon_position!":"column"}},{"name":"align_items_column","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-h"},"center":{"title":"Center","icon":"eicon-align-center-h"},"end":{"title":"End","icon":"eicon-align-end-h"},"stretch":{"title":"Stretch","icon":"eicon-align-stretch-h"}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper":"align-items: {{VALUE}};"},"condition":{"icon_position":"column"}},{"name":"icon_position","label":"Icon Position","type":"choose","control_type":"responsive","separator":"before","options":{"row":{"title":"Left","icon":"eicon-h-align-left"},"column":{"title":"Top","icon":"eicon-v-align-top"},"row-reverse":{"title":"Right","icon":"eicon-h-align-right"}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper":"flex-direction: {{VALUE}};"}},{"name":"icon_sz","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon svg":"height: {{SIZE}}{{UNIT}}; width:auto;","{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"icon_spacing","label":"Icon Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper":"gap: {{SIZE}}{{UNIT}};"}},{"name":"content_alignment","label":"Content Alignment","type":"choose","control_type":"responsive","separator":"before","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justify","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-content":"text-align: {{VALUE}};"}},{"name":"content_spacing","label":"Content Spacing","type":"slider","control_type":"responsive","size_units":["px","custom","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-content":"gap: {{SIZE}}{{UNIT}};"}},{"name":"content_padding","label":"Content Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-content":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"title_position","label":"Title Position","type":"choose","control_type":"responsive","separator":"before","options":{"column":{"title":"Top","icon":"eicon-v-align-top"},"column-reverse":{"title":"Bottom","icon":"eicon-v-align-bottom"}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-content":"flex-direction: {{VALUE}};"}}]},{"name":"tab_icon_style","label":"Icon","tab":"style","controls":[{"name":"icon_box_size","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon":"min-width: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};"}},{"name":"icon_controls","control_type":"tab","tabs":[{"name":"icon_normal","label":"Normal","type":"tab","controls":[{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon":"color: {{VALUE}};"}},{"name":"icon_bacground","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon"},{"name":"icon_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon"},{"name":"icon_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon"},{"name":"icon_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-icon":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"icon_hover","label":"Hover","type":"tab","controls":[{"name":"icon_hover_animation","label":"Hover Animation","type":"select","options":{"":"None","hover-animation-flipX":"Flip X","hover-animation-flipY":"Flip Y","hover-animation-rotate-zoom-in":"Rotate Zoom","hover-animation-shrink-expand":"Shrink Expand","hover-animation-grow-normalize":"Grow Normalize"},"default":""},{"name":"icon_color_hover","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-icon":"color: {{VALUE}};"}},{"name":"icon_hover_background","label":"Background Color","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-icon"},{"name":"icon_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-icon"},{"name":"icon_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-icon"},{"name":"icon_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-icon":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_title_style","label":"Title","tab":"style","controls":[{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title"},{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title":"color: {{VALUE}};"}},{"name":"title_stroke","type":"text-stroke","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title"}]},{"name":"title_hover","label":"Hover","type":"tab","controls":[{"name":"title_hover_style","label":"Hover Style","type":"select","groups":[{"label":"Default","options":{"":"Default"}},{"label":"Underline","options":{"hover-text-underline":"Underline","hover-text-underline--slide-ltr":"Slide LTR","hover-text-underline--slide-rtl":"Slide RTL","hover-text-underline--expland":"Expand","hover-text-fill":"Fill"}}],"default":""},{"name":"link_underline_weight","label":"Underline Weight(px)","type":"slider","size_units":["px"],"default":{"size":1},"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title":"--pxl-height: {{SIZE}}{{UNIT}};"},"condition":{"title_hover_style":["hover-text-underline","hover-text-underline--slide-ltr","hover-text-underline--slide-rtl","hover-text-underline--expland"]}},{"name":"title_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title:hover:not(.hover-text-fill)":"color: {{VALUE}};","{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title.hover-text-fill":"--link-color-hover: {{VALUE}};"}},{"name":"title_hover_stroke","type":"text-stroke","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-title:hover"}]}]}]},{"name":"tab_description_style","label":"Description","tab":"style","controls":[{"name":"description_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-description"},{"name":"description_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-description"},{"name":"description_controls","control_type":"tab","tabs":[{"name":"description_normal","label":"Normal","type":"tab","controls":[{"name":"description_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-description":"color: {{VALUE}};"}},{"name":"description_stroke","type":"text-stroke","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-icon-box-wrapper .pxl-icon-box-description"}]},{"name":"description_hover","label":"Hover","type":"tab","controls":[{"name":"description_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-description":"color: {{VALUE}};"}},{"name":"description_hover_stroke","type":"text-stroke","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-icon-box-wrapper:hover .pxl-icon-box-description"}]}]}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-icon-box-wrapper":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}