<?php

class PxlTimelineCarousel_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_timeline_carousel';
    protected $title = 'Case Timeline Carousel';
    protected $icon = 'eicon-time-line';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_timeline_carousel_content","label":"Timeline Carousel","tab":"content","controls":[{"name":"title_tag","label":"Title HTML Tag","type":"select","seperator":"before","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":"h5"},{"name":"items","label":"Items","type":"repeater","controls":[{"name":"time","label":"Time","type":"text","label_block":true},{"name":"title","label":"Title","type":"text"},{"name":"description","type":"textarea","rows":10,"default":"Ultrices sagittis orci a scelerisque purus semper eget duis at. Sollicitu nibh sit amet."}],"title_field":"{{{title}}}","default":[{"time":"2016","title":"Grainfarmers Formed"},{"time":"2018","title":"Start of Agriculture"},{"time":"2022","title":"Open Our Firm"},{"time":"2025","title":"Farm Remodelacion"}]}]},{"name":"tab_swiper_additional_opts","label":"Additional Options","tab":"content","controls":[{"name":"swiper_controls","control_type":"tab","tabs":[{"name":"swiper_options","label":"Options","type":"tab","condition":{"layout_type":"carousel"},"controls":[{"name":"slide_boxshadow","label":"Slide with Box Shadow","type":"select","options":{"":"Default","swiper-normal":"No","swiper-boxshadow":"Yes"},"default":""},{"name":"effect","label":"Effect","type":"select","options":{"slide":"Slide","fade":"Fade"},"default":"slide"},{"name":"swiper_divider","type":"divider"},{"name":"allow_touch_move","label":"Allow Touch Move","type":"switcher","default":"true"},{"name":"autoplay","label":"Autoplay","type":"switcher","default":""},{"name":"disable_on_interaction","label":"Pause on Interaction","type":"switcher","default":"","condition":{"autoplay!":""}},{"name":"delay","label":"Delay","type":"number","default":3000,"condition":{"autoplay!":""}},{"name":"loop","label":"Infinite Loop","type":"switcher","default":""},{"name":"speed","label":"Animation Speed","type":"number","default":300,"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-container-fade":"--pxl-spacing-inline: {{VALUE}}ms;"}},{"name":"space_between","label":"Space Between(px)","type":"number","control_type":"responsive","condition":{"effect!":"fade"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner":"--pxl-spacing-inline: {{VALUE}}px;"}},{"name":"swiper_pagination","type":"select","label":"Pagination","separator":"before","options":{"":"None","bullets":"Bullets","progressbar":"Progressbar","fraction":"Fraction"}},{"name":"swiper_navigation","label":"Navigation","type":"switcher","default":""},{"name":"use_swiper_nav_widget","label":"Use Navigation Widget","type":"switcher","default":"","condition":{"swiper_navigation!":""}},{"name":"nav_widget_id","type":"text","label":"Enter ID Your Widget Navigation","condition":{"swiper_navigation!":"","use_swiper_nav_widget!":""},"label_block":true,"description":"You need to enter the unique ID you created from the navigation carousel widget, and the navigation with this ID will function as a navigation carousel."},{"name":"nav_btn_icon_prev","label":"Button Icon Prev","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-left.svg","id":3614},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_btn_icon_next","label":"Button Icon Next","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-right.svg","id":3615},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_spacing_top","label":"Spacing Top","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation":"marrgin-top: {{SIZE}}{{UNIT}};"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}}]},{"name":"swiper_responsive","label":"Responsive","type":"tab","controls":[{"name":"custom_slides","label":"Custom Slides","type":"switcher","default":""},{"name":"slides_per_view_xs","label":"Slides Per View(&lt;576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_sm","label":"Slides Per View(\u2265576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_md","label":"Slides Per View(\u2265768px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_lg","label":"Slides Per View(\u2265992px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_xl","label":"Slides Per View(\u22651200px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides_per_view_xxl","label":"Slides Per View(\u22651400px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides","label":"Slides Per View Custom","type":"repeater","condition":{"custom_slides!":""},"controls":[{"name":"slide_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"flex: 0 1 {{SIZE}}{{UNIT}};"}},{"name":"slide_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"slide_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"slide_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"slide_img_dimension":"custom"}}]}]}]}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"img_spacing","label":"Image Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"desc_spacing","label":"Description Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-content":"margin-bottom: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_img_style","label":"Image","tab":"style","controls":[{"name":"img_w","label":"Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured":"width: {{SIZE}}{{UNIT}};"}},{"name":"img_max_w","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"img_min_h","label":"Min Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured":"min-height: {{SIZE}}{{UNIT}};"}},{"name":"img_h","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":2000}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured":"height: {{SIZE}}{{UNIT}};"}},{"name":"img_controls","control_type":"tab","separator":"before","tabs":[{"name":"img_normal","label":"Normal","type":"tab","controls":[{"name":"img_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured":"opacity: {{SIZE}};"}},{"name":"img_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured"},{"name":"img_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured"},{"name":"img_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured"},{"name":"img_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"img_hover","label":"Hover","type":"tab","controls":[{"name":"img_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-item .pxl-timeline-featured":"opacity: {{SIZE}};"}},{"name":"img_hover_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-item .pxl-timeline-featured"},{"name":"img_hover_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-item .pxl-timeline-featured"},{"name":"img_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-item .pxl-timeline-featured"},{"name":"img_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-item .pxl-timeline-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_event_style","label":"Event","tab":"style","controls":[{"name":"event_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-event":"color: {{VALUE}};"}},{"name":"event_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-event"},{"name":"event_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-event"},{"name":"event_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-event"}]},{"name":"tab_title_style","label":"Title","tab":"style","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-title"},{"name":"title_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-title"}]},{"name":"tab_description_style","label":"Description","tab":"style","controls":[{"name":"description_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-description":"color: {{VALUE}};"}},{"name":"description_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-description"},{"name":"description_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-description"},{"name":"description_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-timeline-carousel .pxl-timeline-description"}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-slide":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-slide":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-swiper' );
}