<?php

class PxlProduct_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_product';
    protected $title = 'Case Products';
    protected $icon = 'eicon-products';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_product_layout","label":"Layout","tab":"layout","controls":[{"name":"post_type","type":"hidden","default":"product"},{"name":"layout_type","label":"Layout Type","type":"select","options":{"grid":"Grid","carousel":"Carousel"},"default":"grid","condition":{"layout_product":["product-1","product-3","product-4","product-5"]}},{"name":"layout_product","label":"Select Template of Producto","type":"layoutcontrol","default":"product-1","options":{"product-1":{"label":"Product 1","image":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/product-1.webp"},"product-2":{"label":"Product 2","image":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/product-2.webp"},"product-3":{"label":"Product 3","image":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/product-3.webp"},"product-4":{"label":"Product 4","image":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/product-4.webp"},"product-5":{"label":"Product 5","image":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/product-5.webp"}},"condition":{"post_type":["product"]}}]},{"name":"tab_source","label":"Source","tab":"settings","controls":[{"name":"select_post_by","label":"Select posts by","type":"select","multiple":true,"options":{"term_selected":"Terms selected","post_selected":"Posts selected "},"default":"term_selected"},{"name":"source_product","label":"Select Term of Producto","type":"select2","multiple":true,"options":{"simple|product_type":"simple","food|product_cat":"Food","organico|product_cat":"Org\u00e1nico"},"condition":{"post_type":["product"],"select_post_by":"term_selected"}},{"name":"source_product_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"681":"Organic Sweet Proppol","685":"C\u00farcuma","686":"Esp\u00e1rragos","687":"Jengibre Org\u00e1nico","688":"Palta"},"condition":{"post_type":["product"],"select_post_by":"post_selected"}},{"name":"orderby","label":"Order By","type":"select","default":"date","options":{"date":"Date","ID":"ID","author":"Author","title":"Title","rand":"Random"}},{"name":"order","label":"Sort Order","type":"select","default":"desc","options":{"desc":"Descending","asc":"Ascending"}},{"name":"limit","label":"View Posts","type":"number","default":6}]},{"name":"tab_display_opts","label":"Display","tab":"settings","controls":[{"name":"img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":"","condition":[]},{"name":"custom_img_dimension","label":"Dimension Custom","type":"image_dimensions","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"img_dimension":"custom"}},{"name":"title_tag","label":"Title HTML Tag","type":"select","seperator":"before","options":{"":"Default","h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":""},{"name":"show_rating","label":"Show Rating","type":"switcher","default":"true"},{"name":"show_excerpt","label":"Show Short Description","type":"switcher","default":"true","condition":{"layout_product":["2"]}},{"name":"num_of_words","label":"Number of Words","type":"number","condition":{"show_excerpt!":"","layout_product":["2"]}},{"name":"show_actions","label":"Show Actions","type":"switcher","default":"true"},{"name":"show_add_to_cart","label":"Show Add to Cart Button","type":"switcher","default":"true","condition":{"layout_product":["product-2","product-3","product-5"]}}]},{"name":"tab_grid_add_opts","label":"Additional Options","tab":"settings","controls":[{"name":"grid_controls","control_type":"tab","tabs":[{"name":"grid_options","label":"Options","type":"tab","controls":[{"name":"grid_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .grid .grid-inner":"justify-content: {{VALUE}};"}},{"name":"grid_spacing_inline","label":"Column Spacing(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .grid .grid-inner":"--pxl-spacing-inline: {{SIZE}}{{UNIT}};"}},{"name":"grid_spacing_block","label":"Row Spacing(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .grid .grid-inner":"--pxl-spacing-block: {{SIZE}}{{UNIT}};"}},{"name":"grid_pagination","label":"Pagination","type":"select","separator":"before","default":"","options":{"":"Disable","pagination":"Pagination","loadmore":"Loadmore"}},{"name":"grid_pagination_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .grid .grid-pagination":"justify-content: {{VALUE}};"},"condition":{"grid_pagination":"pagination"}},{"name":"grid_pagination_gap","label":"Gap","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .grid .grid-pagination":"gap: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"grid_pagination_spacing_top","label":"Spacing Top","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"load_more_style","label":"Load More Style","type":"select","options":{"load-more-button-default":"Default","pxl-btn-split":"Split Button"},"default":"load-more-button-default","condition":{"grid_pagination":"loadmore"}},{"name":"btn_load_more_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"condition":{"grid_pagination":"loadmore"},"selectors":{"{{WRAPPER}} .pxl-button-wrapper":"justify-content: {{VALUE}};"}},{"name":"load_more_icon","label":"Load More Icon","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/uploads\/2025\/02\/arrow-long-down.svg","id":10135},"library":"svg"},"condition":{"grid_pagination":"loadmore"}},{"name":"load_more_text","type":"text","label":"Load More Text","condition":{"grid_pagination":"loadmore","loadmore_style":"pxl-btn-split"}},{"name":"loadmore_spacing","label":"Load More Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-load-more-wrapper":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"loadmore"}}]},{"name":"grid_responsive","label":"Responsive","type":"tab","condition":{"layout_type":"grid"},"controls":[{"name":"columns","label":"Columns","type":"select","control_type":"responsive","default":"","options":{"":"Default","100%":"1","50%":"2","33.3333333%":"3","25%":"4","20%":"5","16.666666666%":"6"},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item":"--pxl-width: {{VALUE}};"}},{"name":"grid_items","label":"Columns Custom","type":"repeater","controls":[{"name":"grid_item_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item{{CURRENT_ITEM}}":"--pxl-width: {{SIZE}}{{UNIT}};"}},{"name":"grid_item_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"grid_item_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"grid_item_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"grid_item_img_dimension":"custom"}}]}]}]}],"condition":{"layout_type":"grid","layout_product!":["product-2"]}},{"name":"tab_carousel_add_opts","label":"Additional Options","tab":"settings","controls":[{"name":"swiper_controls","control_type":"tab","tabs":[{"name":"swiper_options","label":"Options","type":"tab","condition":{"layout_type":"carousel"},"controls":[{"name":"slide_boxshadow","label":"Slide with Box Shadow","type":"select","options":{"":"Default","swiper-normal":"No","swiper-boxshadow":"Yes"},"default":""},{"name":"effect","label":"Effect","type":"select","options":{"slide":"Slide","fade":"Fade"},"default":"slide"},{"name":"swiper_divider","type":"divider"},{"name":"allow_touch_move","label":"Allow Touch Move","type":"switcher","default":"true"},{"name":"autoplay","label":"Autoplay","type":"switcher","default":""},{"name":"disable_on_interaction","label":"Pause on Interaction","type":"switcher","default":"","condition":{"autoplay!":""}},{"name":"delay","label":"Delay","type":"number","default":3000,"condition":{"autoplay!":""}},{"name":"loop","label":"Infinite Loop","type":"switcher","default":""},{"name":"speed","label":"Animation Speed","type":"number","default":300,"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-container-fade":"--pxl-spacing-inline: {{VALUE}}ms;"}},{"name":"space_between","label":"Space Between(px)","type":"number","control_type":"responsive","condition":{"effect!":"fade"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner":"--pxl-spacing-inline: {{VALUE}}px;"}},{"name":"swiper_pagination","type":"select","label":"Pagination","separator":"before","options":{"":"None","bullets":"Bullets","progressbar":"Progressbar","fraction":"Fraction"}},{"name":"swiper_navigation","label":"Navigation","type":"switcher","default":""},{"name":"use_swiper_nav_widget","label":"Use Navigation Widget","type":"switcher","default":"","condition":{"swiper_navigation!":""}},{"name":"nav_widget_id","type":"text","label":"Enter ID Your Widget Navigation","condition":{"swiper_navigation!":"","use_swiper_nav_widget!":""},"label_block":true,"description":"You need to enter the unique ID you created from the navigation carousel widget, and the navigation with this ID will function as a navigation carousel."},{"name":"nav_btn_icon_prev","label":"Button Icon Prev","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-left.svg","id":3614},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_btn_icon_next","label":"Button Icon Next","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imaginaweb.pe\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-right.svg","id":3615},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_spacing_top","label":"Spacing Top","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation":"marrgin-top: {{SIZE}}{{UNIT}};"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}}]},{"name":"swiper_responsive","label":"Responsive","type":"tab","controls":[{"name":"custom_slides","label":"Custom Slides","type":"switcher","default":""},{"name":"slides_per_view_xs","label":"Slides Per View(&lt;576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_sm","label":"Slides Per View(\u2265576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_md","label":"Slides Per View(\u2265768px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_lg","label":"Slides Per View(\u2265992px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_xl","label":"Slides Per View(\u22651200px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides_per_view_xxl","label":"Slides Per View(\u22651400px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides","label":"Slides Per View Custom","type":"repeater","condition":{"custom_slides!":""},"controls":[{"name":"slide_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"flex: 0 1 {{SIZE}}{{UNIT}};"}},{"name":"slide_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"slide_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"slide_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"slide_img_dimension":"custom"}}]}]}]}],"condition":{"layout_type":"carousel"}},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"featured_spacing","label":"Featured Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"title_spacing","label":"Title Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-title":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"rating_spacing","label":"Rating Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-poduct-rating":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"rating_gap","label":"Rating Gap","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-rating .rating-star":"gap: {{SIZE}}{{UNIT}};"}},{"name":"layout_max_width","label":"Layout Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-container":"--pxl-max-width: {{SIZE}}{{UNIT}};"},"condition":{"layout_type":"carousel"}},{"name":"price_spacing","label":"Price Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-price":"margin-bottom: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_box_style","label":"Box","tab":"style","controls":[{"name":"box_controls","control_type":"tab","tabs":[{"name":"box_normal","label":"Normal","type":"tab","controls":[{"name":"box_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-product .pxl-product-item"},{"name":"box_border","type":"border","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-item"},{"name":"box_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-item"},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"box_hover","label":"Hover","type":"tabs","controls":[{"name":"box_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-product .pxl-product-item:hover"},{"name":"_box_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item:hover":"border-color: {{VALUE}};"}},{"name":"box_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-item:hover"},{"name":"box_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-item:hover"},{"name":"box_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_hover_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_content_style","label":"Box Content","tab":"style","controls":[{"name":"box_content_heading","type":"heading","label":"Normal","condition":{"layout_post":["post-5"]}},{"name":"content_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-product .pxl-product-content"},{"name":"content_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-content"},{"name":"content_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-content"},{"name":"content_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-content":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"content_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-content":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"tab_featured_style","label":"Product Featured","tab":"style","controls":[{"name":"featured_img_fit","label":"Image Fit","type":"select","options":{"":"Default","cover":"Cover","contain":"Contain"},"default":"","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured img":"object-fit: {{VALUE}};"}},{"name":"featured_width","label":"Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured img":"width: {{SIZE}}{{UNIT}};"}},{"name":"featured_max_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured img":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"featured_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured img":"height: {{SIZE}}{{UNIT}};"}},{"name":"featured_max_height","label":"Max Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured img":"max-height: {{SIZE}}{{UNIT}};"}},{"name":"featured_min_height","label":"Min Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured":"min-height: {{SIZE}}{{UNIT}};"}},{"name":"featured_controls","control_type":"tab","tabs":[{"name":"featured_normal","label":"Normal","type":"tab","controls":[{"name":"featured_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-product .pxl-product-featured"},{"name":"featured_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured img":"opacity: {{SIZE}};"}},{"name":"featured_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-featured img"},{"name":"featured_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-product .pxl-product-featured"},{"name":"featured_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-featured"},{"name":"featured_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"featured_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-featured":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"featured_hover","label":"Hover","type":"tabs","controls":[{"name":"featured_hover_style","label":"Hover Style","type":"select","options":{"":"None","hover-image-default":"Default","hover-image-parallax":"Parallax"},"default":""},{"name":"featured_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item:hover .pxl-post-featured img":"opacity: {{SIZE}};"}},{"name":"featured_hover_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-item:hover .pxl-post-featured img"},{"name":"featured_hover_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-product .pxl-product-item:hover .pxl-post-featured"},{"name":"featured_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-item:hover .pxl-post-featured"},{"name":"featured_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item:hover .pxl-post-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_name_style","label":"Product Name","tab":"style","controls":[{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-name"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-name"},{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-name":"color: {{VALUE}};"}}]},{"name":"title_hover","label":"Hover","type":"tab","controls":[{"name":"title_hover_style","label":"Hover Style","type":"select","groups":[{"label":"Default","options":{"hover-text-default":"Default"}},{"label":"Underline","options":{"hover-text-underline":"Underline","hover-text-underline--slide-ltr":"Slide LTR","hover-text-underline--slide-rtl":"Slide RTL"}}],"default":"hover-text-default"},{"name":"title_underline_h","label":"Underline Weight(px)","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-name":"--pxl-height: {{SIZE}}{{UNIT}};"},"condition":{"title_hover_style":["hover-text-underline","hover-text-underline--slide-ltr","hover-text-underline--slide-rtl"]}},{"name":"title_divider","type":"divider"},{"name":"title_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-name:hover":"color: {{VALUE}};"}}]}]}]},{"name":"tab_price_style","label":"Product Price","tab":"style","controls":[{"name":"price_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-price"},{"name":"price_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-price":"color: {{VALUE}};"}},{"name":"price_controls","control_type":"tab","tabs":[{"name":"price_ins","label":"Ins","type":"tab","controls":[{"name":"price_ins_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-price ins":"color: {{VALUE}} !important;"}},{"name":"price_ins_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-price ins"}]},{"name":"price_del","label":"Del","type":"tab","controls":[{"name":"price_del_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-price del":"color: {{VALUE}} !important;"}},{"name":"price_del_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-price del"}]}]}]},{"name":"tab_rating_style","label":"Product Rating","tab":"style","controls":[{"name":"rating_star_size","label":"Star Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-product-rating svg":"width: {{SIZE}}{{UNIT}}; height:auto;"}},{"name":"star_color","label":"Star Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-rating .rating-star":"color: {{VALUE}};"}}]},{"name":"tab_sale_style","label":"Product Sale","tab":"style","controls":[{"name":"sale_controls","control_type":"tab","tabs":[{"name":"sale_text","label":"Text","type":"tab","controls":[{"name":"sale_text_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-badge"},{"name":"sale_text_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-badge":"color: {{VALUE}};"}},{"name":"sale_text_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-badge"},{"name":"sale_text_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-badge"},{"name":"sale_text_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-badge"},{"name":"sale_text_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-badge":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"sale_text_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-badge":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"sale_percent","label":"Percent","type":"tab","controls":[{"name":"sale_percent_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-percent"},{"name":"sale_percent_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-percent":"color: {{VALUE}};"}},{"name":"sale_percent_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-percent"},{"name":"sale_percent_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-percent"},{"name":"sale_percent_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-percent"},{"name":"sale_percent_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-percent":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"sale_percent_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-product .pxl-product-sale .pxl-sale-percent":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_button_style","label":"Product Button","tab":"style","controls":[{"name":"btn_h","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button":"height: {{SIZE}}{{UNIT}};"}},{"name":"btn_box_size","label":"Box Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button, \r\n                                    {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn,\r\n                                    {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn,\r\n                                    {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn":"height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};"}},{"name":"divider1","type":"divider"},{"name":"btn_controls","control_type":"tab","tabs":[{"name":"btn_normal","label":"Normal","type":"tab","controls":[{"name":"btn_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn":"color: {{VALUE}};"}},{"name":"btn_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-product .pxl-post-button, \r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn,\r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn,\r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn"},{"name":"btn_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-post-button, \r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn,\r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn,\r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn"},{"name":"btn_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-post-button, \r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn,\r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn,\r\n                                            {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn"},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"btn_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"btn_hover_style","label":"Hover Style","type":"select","default":"","options":{"":"Default","hover-underline-ltr":"Underline Slide LTR","hover-underline-rtl":"Underline Slide RTL","hover-underline-expand":"Underline Expand","hover-underline-split":"Underline Split"},"condition":{"layout_service":["service-1","service-4","service-6","service-7"]}},{"name":"btn_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button:hover, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn.woosw-added,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn.woosc-added":"color: {{VALUE}};"}},{"name":"btn_hover_background","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-product .pxl-post-button:hover, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn.woosw-added,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn.woosc-added"},{"name":"btn_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button:hover, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn.woosw-added,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn.woosc-added":"transition: all {{SIZE}}{{UNIT}} linear;"}},{"name":"btn_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-post-button:hover, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn.woosw-added,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn.woosc-added"},{"name":"btn_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-product .pxl-post-button:hover, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn.woosw-added,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn.woosc-added"},{"name":"btn_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button:hover, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn.woosw-added,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn.woosc-added":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-product .pxl-post-button:hover, \r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosq-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosw-btn.woosw-added,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn:hover,\r\n                                                {{WRAPPER}} .pxl-product .pxl-product-item .pxl-product-actions .woosc-btn.woosc-added":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_swiper_bullets_pagination_style","label":"Pagination Bullets","tab":"style","condition":{"swiper_pagination":"bullets"},"controls":[{"name":"bullet_size","label":"Bullet Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};"}},{"name":"bullet_dot_size","label":"Dot Inset","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:before":"inset: {{SIZE}}{{UNIT}};"}},{"name":"divider_bullet_1","type":"divider"},{"name":"bullet_controls","control_type":"tab","tabs":[{"name":"bullet_normal","label":"Normal","type":"tab","controls":[{"name":"bullet_color","label":"Bullet Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"color: {{VALUE}};"}},{"name":"bullet_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"bullet_hover","label":"Hover\/Active","type":"tabs","controls":[{"name":"bullet_hove_color","label":"Bullet Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"color: {{VALUE}};"}},{"name":"_bullet_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-color: {{VALUE}};"}},{"name":"bullet_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_swiper_nav_btn_style","tab":"style","label":"Navigation Button","condition":{"swiper_navigation!":""},"controls":[{"name":"nav_btn_box_size","label":"Box Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, \n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}};"}},{"name":"nav_btn_icon_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button,\n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button svg,\n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button svg":"width: {{SIZE}}{{UNIT}}; height : auto;"}},{"name":"nav_btn_controls","control_type":"tab","tabs":[{"name":"nav_btn_normal","label":"Normal","type":"tab","controls":[{"name":"nav_btn_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"color: {{VALUE}};"}},{"name":"nav_btn_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"nav_btn_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"nav_btn_hover","label":"Hover","type":"tabs","controls":[{"name":"nav_btn_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"color: {{VALUE}};"}},{"name":"_nav_btn_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"border-color: {{VALUE}};"}},{"name":"nav_btn_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"nav_btn_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .grid .grid-item, {{WRAPPER}} .pxl-swiper .swiper-slide":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .grid .grid-item, {{WRAPPER}} .pxl-swiper .swiper-slide":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','pxl-post-grid','agron-swiper' );
}