<?php

class PxlDivider_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_divider';
    protected $title = 'Case Divider';
    protected $icon = 'eicon-divider';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_divider_content","label":"Divider","tab":"content","controls":[{"name":"divider_css_hidden","type":"hidden","selectors":{"{{WRAPPER}}":"pointer-events: none;"}},{"name":"divider_direction","label":"Direction","type":"select","options":{"horizontal":"Horizontal","vertical":"Vertical"},"default":"horizontal"},{"name":"divider_style","label":"Divider Style","type":"select","options":{"":"Default","solid":"Solid","dashed":"Dashed","dotted":"Dotted","double":"Double","custom":"Custom"},"default":""},{"name":"divider_custom","label":"Upload","type":"media","condition":{"divider_style":"custom"}},{"name":"divider_element","label":"Add Element","type":"select","separator":"before","options":{"":"None","title":"Text","icon":"Icon","elements":"Many Elements"},"default":"","condition":{"divider_direction":"horizontal"}},{"name":"items","label":"Items","type":"repeater","condition":{"divider_element":"elements","divider_direction":"horizontal"},"controls":[{"name":"divider_element_icon","label":"Icon","type":"icons","fa4compatibility":"icon","default":{"value":"fas fa-star","library":"Font Awesome 5 Free"}},{"name":"divider_element_offset_left","label":"Left","type":"slider","separator":"before","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper {{CURRENT_ITEM}}":"left: {{SIZE}}{{UNIT}};"}},{"name":"divider_element_offset_right","label":"Right","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper {{CURRENT_ITEM}}":"right: {{SIZE}}{{UNIT}};"}},{"name":"divider_element_size","label":"Font Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper {{CURRENT_ITEM}}":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-divider-wrapper {{CURRENT_ITEM}} svg":"height: {{SIZE}}{{UNIT}}; width:auto;"}},{"name":"dvider_element_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-divider-wrapper {{CURRENT_ITEM}}":"color: {{VALUE}};"}},{"name":"divider_element_display","label":"Display","control_type":"responsive","type":"select","options":{"":"Auto","none":"None"},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper {{CURRENT_ITEM}}":"display: {{VALUE}};"}}]},{"name":"divider_icon","label":"Icon","type":"icons","fa4compatibility":"icon","default":{"value":"fas fa-star","library":"Font Awesome 5 Free"},"condition":{"divider_element":"icon","divider_direction":"horizontal"}},{"name":"divider_title","type":"textarea","rows":3,"label":"Title","condition":{"divider_element":"title","divider_direction":"horizontal"}},{"name":"title_tag","label":"Title HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":"span","condition":{"divider_element":"title","divider_direction":"horizontal"}},{"name":"title_wrap","label":"Title Wrap","type":"choose","control_type":"responsive","options":{"wrap":{"title":"Wrap","icon":"eicon-wrap"},"nowrap":{"title":"No Wrap","icon":"eicon-nowrap"}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title":"white-space: {{VALUE}};"},"condition":{"divider_element":"title","divider_direction":"horizontal"}},{"name":"title_max_width","label":"Title Max Width","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title":"max-width: {{SIZE}}{{UNIT}};"},"condition":{"divider_element":"title","divider_direction":"horizontal"}},{"name":"justify_content_row","label":"Justify Content","type":"choose","separator":"before","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper":"justify-content: {{VALUE}};"},"condition":{"divider_direction":"horizontal"}},{"name":"align_items_row","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-v"},"center":{"title":"Center","icon":"eicon-align-center-v"},"end":{"title":"End","icon":"eicon-align-end-v"}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper":"align-items: {{VALUE}};"},"condition":{"divider_direction":"vertical"}},{"name":"element_spacing","label":"Element Spacing","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper":"gap: {{SIZE}}{{UNIT}};"},"condition":{"divider_element!":"","divider_direction":"horizontal"}}]},{"name":"tab_divider_style","label":"Divider","tab":"style","controls":[{"name":"divider_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item","fields_options":{"color":{"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item":"color: {{VALUE}}","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item:not(.divider-dashed):not(.divider-dotted):not(.divider-double):not(.divider-custom)":"background-color: {{VALUE}}"}}}},{"name":"divider_weight","label":"Weight","type":"slider","separator":"before","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.pxl-divider-horizontal:not(.divider-dashed):not(.divider-dotted):not(.divider-double)":"height: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.pxl-divider-vertical:not(.divider-dashed):not(.divider-dotted):not(.divider-double)":"width: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item:not(.divider-custom)":"--pxl-weight: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.divider-custom img":"height: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.divider-custom svg":"height: {{SIZE}}{{UNIT}}; width: auto;"}},{"name":"divider_width","label":"Width","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item,\r\n                                {{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.divider-custom img":"width: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.divider-custom svg":"width: {{SIZE}}{{UNIT}}; height: auto;"},"condition":{"divider_direction":"horizontal"}},{"name":"divider_max_width","label":"Max Width","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item":"max-width: {{SIZE}}{{UNIT}};"},"condition":{"divider_direction":"horizontal"}},{"name":"divider_height","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item,\r\n                                {{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.divider-custom img":"height: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-item.divider-custom svg":"height: {{SIZE}}{{UNIT}}; width: auto;"},"condition":{"divider_direction":"vertical"}}]},{"name":"tab_title_style","label":"Title","tab":"style","condition":{"divider_element":"title","divider_direction":"horizontal"},"controls":[{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title"},{"name":"title_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title"}]},{"name":"title_highlight","label":"Highlight","type":"tab","controls":[{"name":"title_hl_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title .pxl-text-highlight":"color: {{VALUE}};"}},{"name":"title_hl_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title .pxl-text-highlight"},{"name":"title_hl_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title .pxl-text-highlight"},{"name":"title_hl_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title .pxl-text-highlight"}]}]}]},{"name":"tab_style_icon","label":"Icon","tab":"style","condition":{"divider_element":"icon"},"controls":[{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-icon":"color: {{VALUE}};"}},{"name":"icon_sz","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-icon svg":"width: {{SIZE}}{{UNIT}}; height: auto;","{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-icon":"font-size: {{SIZE}}{{UNIT}};"}}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-icon, {{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-divider-wrapper .pxl-divider-icon, {{WRAPPER}} .pxl-divider-wrapper .pxl-divider-title":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}