<?php

class PxlCounter_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_counter';
    protected $title = 'Case Counter';
    protected $icon = 'eicon-counter';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_counter_content","label":"Counter","tab":"content","controls":[{"name":"counter_style","label":"Layout Style","type":"select","options":{"default":"Default","style1":"Style 1","style2":"Style 2","custom":"Custom"},"default":"default"},{"name":"starting_number","label":"Starting Number","type":"number","default":1},{"name":"ending_number","label":"Ending Number","type":"number","default":100},{"name":"number_prefix","label":"Number Prefix","type":"text"},{"name":"number_suffix","label":"Number Suffix","type":"text"},{"name":"number_anim_duration","label":"Animation Duration(ms)","type":"number","default":2000,"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-number":"animation-duration: {{VALUE}}ms;"}},{"name":"number_delimiter","label":"Number Delimiter","type":"select","options":{"":"None",".":"Dot",",":"Comma"," ":"Space"},"default":""},{"name":"number_tag","label":"Number HTML Tag","type":"select","default":"div","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"}},{"name":"description","label":"Description","type":"textarea","separator":"before","rows":5,"default":"Description here"}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"box_size","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-counter":"width: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};"}},{"name":"flex_direction","label":"Flex Direction","type":"choose","control_type":"responsive","options":{"column":{"title":"Column","icon":"eicon-arrow-down"},"column-reverse":{"title":"Column Reverse","icon":"eicon-arrow-up"}},"selectors":{"{{WRAPPER}} .pxl-counter":"flex-direction: {{VALUE}};"}},{"name":"align_items_h","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-h"},"center":{"title":"Center","icon":"eicon-align-center-h"},"end":{"title":"End","icon":"eicon-align-end-h"},"stretch":{"title":"Stretch","icon":"eicon-align-stretch-h"}},"selectors":{"{{WRAPPER}} .pxl-counter":"align-items: {{VALUE}};"}},{"name":"justify_content_column","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-v"},"center":{"title":"Center","icon":"eicon-justify-center-v"},"end":{"title":"End","icon":"eicon-justify-end-v"},"space-around":{"title":"Space Around","icon":"eicon-justify-space-around-v"},"space-evenly":{"title":"Space Evenly","icon":"eicon-justify-space-evenly-v"},"space-between":{"title":"Space Between","icon":"eicon-justify-space-between-v"}},"selectors":{"{{WRAPPER}} .pxl-counter":"justify-content: {{VALUE}};"}},{"name":"spacing","label":"Gap","type":"slider","control_type":"responsive","size_units":["px","custom"],"separator":"before","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-counter":"gap: {{SIZE}}{{UNIT}};"}},{"name":"number_heading","label":"Number","type":"heading","separator":"before"},{"name":"num_align_items","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-v"},"center":{"title":"Center","icon":"eicon-align-center-v"},"end":{"title":"End","icon":"eicon-align-end-v"}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-number":"align-items: {{VALUE}};"}},{"name":"number_affix_spacing","label":"Affix Spacing","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-number":"gap: {{SIZE}}{{UNIT}};"}},{"name":"desc_text_align","label":"Text Alignment","type":"choose","control_type":"responsive","separator":"before","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justify","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-description":"text-align: {{VALUE}};"}}]},{"name":"tab_box_style","label":"Box","tab":"style","controls":[{"name":"box_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-counter"},{"name":"box_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-counter"},{"name":"box_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-counter"},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-counter":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-counter":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"tab_number_style","label":"Number","tab":"style","controls":[{"name":"number_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-number":"color: {{VALUE}};"}},{"name":"number_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-number"},{"name":"number_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-number"},{"name":"number_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-number"},{"name":"divider_number","type":"divider"},{"name":"number_fix_controls","control_type":"tab","tabs":[{"name":"num_prefix_normal","label":"Prefix","type":"tab","controls":[{"name":"num_prefix_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-number .number-prefix":"color: {{VALUE}};"}},{"name":"num_prefix_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-number .number-prefix"}]},{"name":"num_suffix_normal","label":"Suffix","type":"tab","controls":[{"name":"num_suffix_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-number .number-suffix":"color: {{VALUE}};"}},{"name":"num_suffix_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-number .number-suffix"}]}]}]},{"name":"tab_description_style","label":"Description","tab":"style","controls":[{"name":"description_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-counter .pxl-counter-description":"color: {{VALUE}};"}},{"name":"description_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-description"},{"name":"description_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-description"},{"name":"description_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-counter .pxl-counter-description"}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-counter":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-counter":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-counter' );
}